// TcontrolSlide.cpp
#include "TControlSlide.h"

//#include <stdlib.h>
#include <errno.h>

TControlSlide::TControlSlide(BRect frame, const char *name, BTextControl *target, long min, long max, orientation posture, long factor, char *format )
	: BScrollBar(frame,name, NULL, min, max, posture)
{
	mControl = target;
	if ( factor == 0)
		mFactor = 1;
	else
		mFactor = factor;
		
	
	mControl->SetMessage( new BMessage('Chek') );
	
	mFormat = new char [strlen(format)+1]; 
	strcpy(mFormat,format);
	
	ValueChanged(min);
}

TControlSlide::~TControlSlide()
{
	delete mFormat;
}
	
void 
TControlSlide::ValueChanged(float inValue)
{
	if (mControl != NULL)
	{
		char	theString[64];
		sprintf(theString,mFormat, inValue/mFactor);
		mControl ->SetText(theString);
	}
}

void
TControlSlide::AttachedToWindow()
{
	mControl->SetTarget(this);
}

void
TControlSlide::MessageReceived(BMessage *inMsg)
{
	switch( inMsg->what)
	{
		case 'Chek':
			// Check the the user entered valid data
			// Reset if necessary
//			char	theString[64];
			const char *theText = mControl->Text();
			double theNum = atof(theText);
			float	theValue;
			float	min,max;
			
			{
				theNum *= mFactor; // Convert to integer
				
				GetRange(&min,&max);
					
				if ( theNum < min )
				{
					theValue = min;
				}
				else
				if ( theNum > max )
				{
					theValue = max;
				}
				else
					theValue = theNum;

				// Update the scroll and everything else will follow	
				SetValue(theValue);
			}
			
			break;
		default:
			BScrollBar::MessageReceived(inMsg);
			break;
	}
}

